/****************************************************************************************************************************************************************/
create or replace
PROCEDURE leer_file IS
cadena VARCHAR2(32767); 
Vfile UTL_FILE.FILE_TYPE; 
BEGIN 
 -- En este ejemplo leo una linea del fichero prueba.txt 
 -- Abro fichero en lectura (Read)
 Vfile := UTL_FILE.FOPEN('USER_DIR','prueba.csv','R',256); 
 -- Leo del fichero
 UTL_FILE.GET_LINE(Vfile,cadena,32767); 
 -- Cierro fichero
 UTL_FILE.FCLOSE(Vfile);
 -- Muestro por partalla la linea 
 dbms_output.put_line(cadena); 
END;
/
/****************************************************************************************************************************************************************/
create or replace
PROCEDURE modificarfechaactualizacion
     IS
         n_acta number;
         ano_acta number;
         c_territ varchar2(2);
         ver number;
         version_acta number;
         factu DATE;
         F_VALIDAC DATE;
         QUERY VARCHAR2(25000);
         CURSOR actasConsultar IS
           select actas.n_acta_016,ano_acta_016,c_territ_016,version_016, version_acta_061, actas.factu_016, incidencias.F_VALIDAC_061 from w83b16t00 actas, w83b61t00 incidencias where
actas.n_acta_016=incidencias.n_acta_061 and
actas.ano_acta_016=incidencias.ano_acta_061 and
actas.version_016=incidencias.version_acta_061 and
actas.c_territ_016=incidencias.c_territ_061 and
actas.factu_016 <> incidencias.F_VALIDAC_061 and actas.version_016 <>0 and actas.c_territ_016 IN (01,48,20);
   BEGIN
       OPEN actasConsultar;
       LOOP
            FETCH actasConsultar INTO  n_acta ,
         ano_acta ,
         c_territ,
         ver,
         version_acta ,
         factu ,
         F_VALIDAC ;
            EXIT WHEN actasConsultar%NOTFOUND;
            QUERY:='N_ACTA ' ||n_acta ||', C_TERRIT '|| c_territ || ', VERSION_016 ' || ver|| ', ANO_ACTA_016 ' ||ano_acta || ',FACTU_016 ' || factu ;
            DBMS_OUTPUT.PUT_LINE(QUERY);
             UPDATE w83b16t00 set factu_016=F_VALIDAC where n_acta_016=n_acta and c_territ_016=c_territ and version_016=ver and ano_acta_016=ano_acta;
        END LOOP;
        CLOSE actasConsultar;
END;
/
/****************************************************************************************************************************************************************/
create or replace
Procedure      w83bBajaActas
IS
   nacta NUMBER;
   anoacta NUMBER;
   territ VARCHAR2(2);
   ver NUMBER;
   fechabaja DATE;
   cbaja NUMBER;
   CURSOR actasBaja IS
    SELECT   n_acta_016, ano_acta_016,
         c_territ_016, version_016,
         F_BAJA_016,
         cbaja_016
       FROM w83b16s00 actas
       WHERE f_baja_016 IS NOT NULL;     
   BEGIN
       OPEN actasBaja;     
       LOOP
         FETCH actasBaja INTO 
         nacta,
         anoacta,territ,ver,fechabaja,cbaja;
            EXIT WHEN actasBaja%NOTFOUND;               
              IF (ver>0) THEN
                DBMS_OUTPUT.PUT_LINE('nacta= '||nacta||' anoacta= '||anoacta||' territ= '||territ||' ver= '||ver||' fechabaja= '||fechabaja||' cbaja= '||cbaja);
                UPDATE w83b16s00 SET f_baja_016=fechabaja,cbaja_016=cbaja WHERE n_acta_016=nacta AND ano_acta_016=anoacta AND c_territ_016=territ;  
              END IF;                       
        END LOOP;
        CLOSE actasBaja;
END; 
/
/****************************************************************************************************************************************************************/
create or replace
PROCEDURE      w83bHistorialImpugnaciones
   ( num_impugnacion IN NUMBER, ano_impugnacion IN NUMBER, c_territ IN VARCHAR2, factu IN VARCHAR2, usuario_act IN VARCHAR2, desc_cas IN VARCHAR2, desc_eus IN VARCHAR2 )
IS
BEGIN
INSERT INTO W83B73T00 t73
( t73.N_IMPUG_073, t73.ANO_IMPUG_073, t73.C_TERRIT_073, t73.FACTU_073,t73.USUA_073,
  t73.DESC_CAS_073, t73.DESC_EUS_073
)
VALUES (num_impugnacion ,ano_impugnacion,c_territ, TO_DATE(factu,'DD/MM/YYYY HH24:MI:SS') , usuario_act, desc_cas, desc_eus);
COMMIT;
EXCEPTION
WHEN OTHERS THEN
      RAISE_APPLICATION_ERROR(-20001,'Ha ocurrido un error al insertar en historial - '||SQLCODE||' -ERROR- '||SQLERRM);
END;
/
/****************************************************************************************************************************************************************/
create or replace
PROCEDURE      w83bHistorialPreavisos
   ( num_preaviso IN NUMBER, ano_preaviso IN NUMBER, c_territ IN VARCHAR2, factu IN VARCHAR2, usuario_act IN VARCHAR2, desc_cas IN VARCHAR2, desc_eus IN VARCHAR2 )
IS
BEGIN
INSERT INTO W83B55T00 t55
( t55.N_PREAVISO_055, t55.ANO_PREAVISO_055, t55.C_TERRIT_055, t55.FACTU_055,t55.USUA_055,
  t55.DESC_CAS_055, t55.DESC_EUS_055
)
VALUES (num_preaviso ,ano_preaviso,c_territ, TO_DATE(factu,'DD/MM/YYYY HH24:MI:SS') , usuario_act, desc_cas, desc_eus);
EXCEPTION
WHEN OTHERS THEN
      RAISE_APPLICATION_ERROR(-20001,'Ha ocurrido un error al insertar en historial - '||SQLCODE||' -ERROR- '||SQLERRM);
END;
/
/****************************************************************************************************************************************************************/
